clc
clear
close all
set(0,'defaultTextInterpreter','latex'); %trying to set the default
set(0,'defaultLegendInterpreter','latex'); %trying to set the default
% set(0,'defaultAxesFontSize',20);
% set(0,'defaultAxesFontName','TimesNewRoman');

%Input data
%Physical parameters
Rg=287.053; %Costante dell'aria (J/kg/K)
mu=1.81e-5; %viscosita` dinamica dell'aria a 20C (Pa s)
pa=101325;
Temp=293;                  %Temperature (K)
rho=pa/(Rg*Temp);
dt=2.5e-8;                %Time Step (s)
cG=60000/rho;
%Geometrical parameters
R1 =16e-3 ; % inner radius (m)
R2 =33e-3 ;  % outer radius (m)
Rm=(R1+R2)/2;
T1d=0; %deg
T2d=55; %deg
T_tiltd = 16.5; %deg
T1=T1d*pi/180;
T2=T2d*pi/180;
T_tilt = T_tiltd*pi/180;
% h_max=40e-6;
h_min=5e-6;
sh=25e-6;
F_ext_vec = [2.5 4:10];


% Lambda=100;
% omega0=Lambda*pa*(h_min/Rm)^2/(6*mu)*1e-3;
% Omega_rpm=(omega0:omega0*0.5:7*omega0)*1e3;
Omega_rpm = [5 10:10:70]*1e3;
Omega=Omega_rpm*2*pi/60;
no_pad=6;

%Definizione numero elementini nelle due direzioni
M=30; %direzione radiale
N=30; %direzione circonferenziale
deltar=(R2-R1)/(M-1);
deltat=(T2-T1)/(N-1);
nR =linspace(R1,R2,M); %Vettore dei raggi
nT =linspace(T1,T2-deltat,N);%Vettore degli angoli
%caso di periodicit
% nT=[nT(end), nT, nT(1)];
[T,R] = meshgrid(nT,nR) ; %crea le coordinate di tutti i punti %nR lo replica su ogni riga %nT su ogni colonna
% Convert grid to cartesian coordintes
X = R.*cos(T); 
Y = R.*sin(T);
%Definisco valore raggio
Rv=sqrt(X.^2+Y.^2);

for F_ext_i = 1:length(F_ext_vec)
H0 = ones(M,N)*h_min;
% tilt_start = round(N*0.3);
for ind_gap=1:M
    h0=h_min+sh*(1-nR(ind_gap)*nT./(nR(ind_gap)*nT(end)));
    H0(ind_gap,:)=h0;
end
%Condizioni iniziali
h0_dot=0;
H0_dot=ones(size(H0))*h0_dot;

figure
surf(X*1e3,Y*1e3,H0*1e6), hold on
xlabel('X (mm)'),ylabel('Y (mm)'),zlabel('Air Gap Height ($\mu m$)')
pause(0.1)


%Variable Initialization
%COndizioni Periodicit
% pold=ones(N+2,M)*pa; %N+2 per periodicit circolare lungo theta
% pnew=ones(N+2,M)*pa;
%COndizioni di Dirichelet p=Pa sul bordo esterno
Pold=ones(M,N)*pa; %MODIFICATO
Pnew=Pold;


%Condizione statica iniziale
   omega=Omega(1);
   tic  
   err_P=10;
   err_F=10;
   err_G=10;

   %portate uscita nodo
   GN=zeros(M,N); %N and M are for BC
   GS=zeros(M,N);
   gO=zeros(M,N);
   gE=zeros(M,N);
   % F0=0;
   F1=0;

   iter=0;
   toll=1e-6;
   while abs(err_P)>toll || abs(err_G)>2e-3
   iter=iter+1;
   F0=F1;
   Pold=Pnew;


     ii=2:M-1;   jj=2:N-1; %Nodi interni
    %Calcolo portata uscita radiale
    GN(ii,jj)=-(Pold(ii-1,jj).*H0(ii-1,jj).^3.*Rv(ii-1,jj)+Pold(ii,jj).*H0(ii,jj).^3.*Rv(ii,jj))./(24*mu*Rg*Temp*deltar).*(Pold(ii,jj)-Pold(ii-1,jj));
    GS(ii,jj)=-(Pold(ii,jj).*H0(ii,jj).^3.*Rv(ii,jj)+Pold(ii+1,jj).*H0(ii+1,jj).^3.*Rv(ii+1,jj))./(24*mu*Rg*Temp*deltar).*(Pold(ii+1,jj)-Pold(ii,jj));
    %Calcolo portata uscita circonferenziale
    gOp(ii,jj)=-(Pold(ii,jj-1).*H0(ii,jj-1).^3+Pold(ii,jj).*H0(ii,jj).^3)./(12*mu*Rg*Temp*(Rv(ii,jj-1)+Rv(ii,jj)).*deltat).*(Pold(ii,jj)-Pold(ii,jj-1));
    gOc(ii,jj)=omega*(Pold(ii,jj-1).*H0(ii,jj-1).*Rv(ii,jj-1)+Pold(ii,jj).*H0(ii,jj).*Rv(ii,jj))./(4*Rg*Temp);
    gO(ii,jj)=gOp(ii,jj)+gOc(ii,jj);
    gEp(ii,jj)=-(Pold(ii,jj).*H0(ii,jj).^3+Pold(ii,jj+1).*H0(ii,jj+1).^3)./(12*mu*Rg*Temp*(Rv(ii,jj)+Rv(ii,jj+1)).*deltat).*(Pold(ii,jj+1)-Pold(ii,jj));
    gEc(ii,jj)=omega*(Pold(ii,jj).*H0(ii,jj).*Rv(ii,jj)+Pold(ii,jj+1).*H0(ii,jj+1).*Rv(ii,jj+1))./(4*Rg*Temp);
    gE(ii,jj)=gEp(ii,jj)+gEc(ii,jj);
    %Calcolo pressione meato da equazione di continuit
    Pnew(ii,jj)=Pold(ii,jj)+((GN(ii,jj)-GS(ii,jj))*deltat+(gO(ii,jj)-gE(ii,jj))*deltar).*(dt*Rg*Temp)./(H0(ii,jj).*Rv(ii,jj)*deltar*deltat);
    
    %Calcolo della portata in uscita O-N-E-S
    Gin=sum(GN(ii,jj)*deltat+gO(ii,jj)*deltar,'all');
    Gout=sum(GS(ii,jj)*deltat+gE(ii,jj)*deltar,'all');

    %Calcolo errore Pressione
    err_P=abs(max((Pnew(:)-Pold(:))./Pold(:)));
    % Err_P_i(iter)=err_P;
    err_G_num=sum(Gin-Gout,'all');
    err_G=err_G_num/Gout;

    %Diverge?
    if any(isnan(Pnew(:))) || any(isinf(Pnew(:)))
        fprintf('Iterations diverge\n');
        return;
    end   
    
    %Calcolo della capacit di carico
    F1=sum((Pnew-pa)*deltar*deltat.*Rv,'all');
  
   end
   toc
   
   figure
   surf(X*1e3,Y*1e3,Pnew)
   xlabel('X (mm)'),ylabel('Y (mm)'),zlabel('Pressure (Pa)')
   grid on
   pause(0.5)

   % save statica
 %% Simulazione dinamica
 % load statica

    %Carico applicato sul prototipo
    inclinazione=4.4;%(deg)
    Area=pi*(R2^2-R1^2);
    massa=1.334;%(kg)
    p_ext=0;
    %1 N=471.57 Pa *Area
    % F_ext=massa*9.806*sind(inclinazione)+p_ext*Area;
    F_ext=F_ext_vec(F_ext_i);
    % F_ext=F1*no_pad;
    F0=F1;  
   
   % Omega_rpm=(omega0:omega0*0.5:7*omega0)*1e3;
   % Omega=Omega_rpm*2*pi/60; 
% Creation of save cells
P_cell = cell(length(Omega),1);
F_cell = cell(length(Omega),1);
h_cell = cell(length(Omega),1);
h_dot_cell = cell(length(Omega),1);
time_cell = cell(length(Omega),1);
global_contatore = ones(length(Omega)+1,1);

W = zeros(size(Omega));
Qin = W;
Qout = W;
Gap = W;
     % H0t=[];
     % H0t_dot=[];
     % H0t_ddot=[];
     % Ft=[];
     % Time=[];
     % Gint=[];
     % Goutt=[];
     % Err_P=[];
     % Err_h=[];
     % Err_F=[];
data_vec_size = 1e5;
H0t=zeros(data_vec_size,1);
H0t_dot=zeros(data_vec_size,1);
H0t_ddot=zeros(data_vec_size,1);
Ft=zeros(data_vec_size,1);
Time=zeros(data_vec_size,1);
Gint=zeros(data_vec_size,1);
Goutt=zeros(data_vec_size,1);
Err_P=zeros(data_vec_size,1);
Err_h=zeros(data_vec_size,1);
Err_F=zeros(data_vec_size,1);
position = 0;

%Condizioni iniziali
t=0;
h0=h_min;
h0_dot=0;
H0_dot=ones(size(H0))*h0_dot;


for omega_ind=1:length(Omega)
   omega=Omega(omega_ind);
    %Smorzamento numerico
    c_num=0.5e2;
    if omega_ind==1
    c_num=0;  
    end
%    %Calcolo passo di tempo ottimizzato
%     CS=0.07*(omega0/(omega*2));
%     CS=0.07;
% 
%         if omega_ind==1;
%     CS=0.07;  
%     end
%     dtVisc=CS*(rho*min(deltat,deltar)^2)/(4*mu);
%     dtConv=CS/abs((2*omega*R2));
%     dtAcus=CS*min(deltat,deltar)/sqrt(2*1.4*Rg*Temp);
%     dtOPT=min([dtVisc dtConv dtAcus]);
%     dt=dtOPT;     
   
    periodo=(2*pi)/(omega);
    punti_per_giro=50;
    ts=periodo/punti_per_giro;
    no_punti=round(ts/dt);
    tic  
    err_P=10;
    err_F=10;
    err_G=10;
    err_h=10;
    h0_dot=0;

   iter=0;
   contatore=0;
   

   while abs(err_h)>toll || abs(err_F)>toll*500 || abs(h0_dot)>toll
   
   
   iter=iter+1;
   t=t+dt;
   contatore=contatore+1;

    ii=2:M-1;   jj=2:N-1; %Nodi interni
    %Calcolo portata uscita radiale
    GN(ii,jj)=-(Pold(ii-1,jj).*H0(ii-1,jj).^3.*Rv(ii-1,jj)+Pold(ii,jj).*H0(ii,jj).^3.*Rv(ii,jj))./(24*mu*Rg*Temp*deltar).*(Pold(ii,jj)-Pold(ii-1,jj));
    GS(ii,jj)=-(Pold(ii,jj).*H0(ii,jj).^3.*Rv(ii,jj)+Pold(ii+1,jj).*H0(ii+1,jj).^3.*Rv(ii+1,jj))./(24*mu*Rg*Temp*deltar).*(Pold(ii+1,jj)-Pold(ii,jj));
    %Calcolo portata uscita circonferenziale
    gOp(ii,jj)=-(Pold(ii,jj-1).*H0(ii,jj-1).^3+Pold(ii,jj).*H0(ii,jj).^3)./(12*mu*Rg*Temp*(Rv(ii,jj-1)+Rv(ii,jj)).*deltat).*(Pold(ii,jj)-Pold(ii,jj-1));
    gOc(ii,jj)=omega*(Pold(ii,jj-1).*H0(ii,jj-1).*Rv(ii,jj-1)+Pold(ii,jj).*H0(ii,jj).*Rv(ii,jj))./(4*Rg*Temp);
    gO(ii,jj)=gOp(ii,jj)+gOc(ii,jj);
    gEp(ii,jj)=-(Pold(ii,jj).*H0(ii,jj).^3+Pold(ii,jj+1).*H0(ii,jj+1).^3)./(12*mu*Rg*Temp*(Rv(ii,jj)+Rv(ii,jj+1)).*deltat).*(Pold(ii,jj+1)-Pold(ii,jj));
    gEc(ii,jj)=omega*(Pold(ii,jj).*H0(ii,jj).*Rv(ii,jj)+Pold(ii,jj+1).*H0(ii,jj+1).*Rv(ii,jj+1))./(4*Rg*Temp);
    gE(ii,jj)=gEp(ii,jj)+gEc(ii,jj);
    %Calcolo pressione meato da equazione di continuit
    Pnew(ii,jj)=Pold(ii,jj)+(((GN(ii,jj)-GS(ii,jj))*deltat+(gO(ii,jj)-gE(ii,jj))*deltar)./(Rv(ii,jj)*deltar*deltat)-Pold(ii,jj).*H0_dot(ii,jj)./(Rg*Temp)).*(dt*Rg*Temp)./(H0(ii,jj));

    %Calcolo della portata in uscita O-N-E-S
    Gin=sum(GN(ii,jj)*deltat+gO(ii,jj)*deltar,'all');
    Gout=sum(GS(ii,jj)*deltat+gE(ii,jj)*deltar,'all');


    %Diverge?
    if any(isnan(Pnew(:))) || any(isinf(Pnew(:)))
        fprintf('Iterations diverge\n');
        return;
    end


%Calcolo della capacit di carico
F1=sum((Pnew-pa)*deltar*deltat.*Rv,'all');

%Calcolo velocit
h1_dot=h0_dot+(F1*no_pad-c_num*h0_dot-F_ext)*dt/massa;
%Calcolo meato minimo di equilibrio
h1=h0+h0_dot*dt;
%Calcolo accelerazione
h0_ddot=(h1_dot-h0_dot)/dt;

%Calcolo errore
err_P=abs(max((Pnew(:)-Pold(:))./Pold(:)));
err_F=(F1*no_pad-F_ext)/F1*no_pad;
err_h=(h1-h0)/h0;
err_G_num=sum(Gin-Gout,'all');
err_G=err_G_num/Gout;
if sum(iter==(1:100)) && omega_ind~=1
   err_F = 1;
end

% Aggiorno le variabili
h0=h1;
H0(:,:) = h0;
for ind_gap=1:M
    h_ind=h0+sh*(1-nR(ind_gap)*nT./(nR(ind_gap)*nT(end)));
    H0(ind_gap,:)=h_ind;
end

h0_dot=h1_dot;
H0_dot=ones(size(H0))*h0_dot;
Pold=Pnew;
F0=F1;

  if contatore==round(no_punti)
      position = position+1;
      H0t(position)=h0;
      H0t_dot(position)=h0_dot;
      H0t_ddot(position)=h0_ddot;
      Ft(position)=F0*no_pad;
      Time(position)=t;
      Gint(position)=Gin;
      Goutt(position)=Gout;
      Err_P(position)=err_P;
      Err_h(position)=err_h;
      Err_F(position)=err_F;

     % H0t=[H0t h0];
     % H0t_dot=[H0t_dot h0_dot];
     % H0t_ddot=[H0t_ddot h0_ddot];
     % Ft=[Ft F0*no_pad];
     % Time=[Time t];
     % Gint=[Gint Gin];
     % Goutt=[Goutt Gout];
     % Err_P=[Err_P err_P];
     % Err_h=[Err_h err_h];
     % Err_F=[Err_F err_F];      
   contatore=0;
  end
  
   end
   toc
   W(omega_ind)=F0*no_pad;
   Qin(omega_ind)=Gin*cG;
   Qout(omega_ind)=Gout*cG;
   Gap(omega_ind)=h0;
    
   
       %Diverge?
    if any(isnan(Pnew(:))) || any(isinf(Pnew(:)))
        fprintf('Iterations diverge\n');
        return;  
    end

   figure
   surf(X*1e3,Y*1e3,Pnew)
   xlabel('X (mm)'),ylabel('Y (mm)'),zlabel('Pressure (Pa)')
   title(['$\omega=$' num2str(Omega_rpm(omega_ind)*1e-3)...
       ' krpm'])
   grid on
   pause(0.1)

   % global_contatore(omega_ind+1) = length(Ft);
   global_contatore(omega_ind+1) = position;
   pos = global_contatore(omega_ind:omega_ind+1);
   % Save all corresponding data
   P_cell{omega_ind} = Pnew;
   F_cell{omega_ind} = Ft(pos(1):pos(2));
   h_cell{omega_ind} = H0t(pos(1):pos(2))*1e6;
   h_dot_cell{omega_ind} = H0t_dot(pos(1):pos(2))*1e6;
   time_cell{omega_ind} = Time(pos(1):pos(2));
    
   figure
   hold on
   plot(Time(1:position),Ft(1:position),'b')
   plot(Time,F_ext*ones(size(Time)),'r')
   hold off
   xlabel('Time (s)'),ylabel('F(t) (N)')
   title(['Bearing load capacity vs ' num2str(F_ext) ' N of external force'])
   legend('Bearing force','External load')
   grid on,
   pause(0.1)
   
   figure
   plot(Time(1:position),H0t_dot(1:position)*1e6,'r')
   xlabel('Time (s)'),ylabel('$\dot{h} (t)$ $\frac{\mu m}{s}$')
   grid on,
   pause(0.1)
   
   figure
   plot(Time(1:position),H0t(1:position)*1e6,'k')
   xlabel('Time (s)'),ylabel('h(t) ($\mu m$)')
   grid on,
   pause(0.1)
 
end
H0t(position+1:end)=[];
H0t_dot(position+1:end)=[];
H0t_ddot(position+1:end)=[];
Ft(position+1:end)=[];
Time(position+1:end)=[];
Gint(position+1:end)=[];
Goutt(position+1:end)=[];
Err_P(position+1:end)=[];
Err_h(position+1:end)=[];
Err_F(position+1:end)=[];


%% Curve Caratteristiche
% Capacit di carico
figure 
plot(Omega_rpm(1:length(W))*1e-3,W,'b'),hold on 
plot(Omega_rpm(1:length(W))*1e-3,W,'ro'),hold on 
xlabel('Angular Speed $\omega$ (krpm)'),ylabel('Load Capacity $W$ (N)'),
% legend('Numerical','Experimental')
grid on,

% Portata Ingresso-Uscita
figure 
plot(Omega_rpm(1:length(W))*1e-3,Qin,'b'),hold on 
plot(Omega_rpm(1:length(W))*1e-3,Qout,'ro'),hold on 
xlabel('Angular Speed $\omega$ (krpm)'),ylabel('Air Flow $Q$ (l/min)'),
% legend('Numerical','Experimental')
grid on,
   

% Meato
figure 
plot(Omega_rpm(1:length(W))*1e-3,Gap*1e6,'b'),hold on 
plot(Omega_rpm(1:length(W))*1e-3,Gap*1e6,'ro')
xlabel('Angular Speed $\omega$ (krpm)'),ylabel('Minimum film thickness $h$ ($\mu m$)'),
% legend('Numerical','Experimental')
grid on,

%    
% %portanza
% figure               
% plot(H0(1:length(Flow1)),Load,'b'),hold on
% % plot(gap_nw,portanza_nw,'bo','linewidth',2),
% Portata=['plot(h_ps' num2str(p_rel*100) '_' num2str(Test) '+shift,F_ps' num2str(p_rel*100) '_' num2str(Test) ', ''ko''), hold on'];
% eval(Portata)
% legend('Numerical','Experimental')   
% xlabel('Air gap height'),ylabel('Force')
% grid on,set(gca,'FontSize', 24)

%% Salvataggio
h_TB=Gap(1:length(W))*1e6;
W_TB=W(1:length(W));
w_TB_rpm=Omega_rpm(1:length(W))*1e-3;
Q_TB=Qin;

file_name = ['Spiral_Dynamic_' num2str(round(F_ext*100)/100) 'N.mat'];
save(file_name,"F_cell","h_cell","P_cell","h_dot_cell","time_cell","X","Y","F_ext",...
    "Omega_rpm","h_TB","W_TB","w_TB_rpm","Q_TB");


load(file_name)
figure 
plot(w_TB_rpm,W_TB,'-ob','MarkerEdgeColor','r') 
xlabel('Angular Speed $\omega$ (krpm)')
ylabel('Load Capacity $W$ (N)')
% legend('Numerical','Experimental')
grid on,

% Portata Ingresso-Uscita
figure 
plot(w_TB_rpm,Q_TB,'-ob','MarkerEdgeColor','r') 
xlabel('Angular Speed $\omega$ (krpm)')
ylabel('Air Flow $Q$ (l/min)')
% legend('Numerical','Experimental')
grid on,
   

% Meato
figure 
plot(w_TB_rpm,h_TB,'-ob','MarkerEdgeColor','r')
xlabel('Angular Speed $\omega$ (krpm)')
ylabel('Minimum film thickness $h$ ($\mu m$)')
% legend('Numerical','Experimental')
grid on

end